<?php
namespace Elementor;
use WP_Query;
class Dirpro_Recent_Posts_Widget extends Widget_Base {

	public function get_name() {

		return 'dirpro_recent_post';
	}

	public function get_title() {
		return esc_html__( 'All Listings + Map', 'ivdirectories' );
	}

	public function get_icon() {

		return 'eicon-post-excerpt';
	}

	public function get_categories() {
		return [ 'dirpro_elements' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'recent_post_settings',
			[
				'label' => esc_html__( 'All Listing: Map + Search', 'ivdirectories' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'template_option',
			[
			'label'       => esc_html__( 'Template Type', 'ivdirectories' ),
			'type'        => Controls_Manager::SELECT,
			'label_block' => true,			
			'default' => 'style-4',
				'options' => [
					'style-4'   => esc_html__( 'Grid View : Top Filter', 'ivdirectories' ),
					// for future 'style-5'   => esc_html__( 'List View : Left Faceted Filter', 'ivdirectories' ),
					// for future 'style-6'   => esc_html__( 'Grid View : Left Faceted Filter', 'ivdirectories' ),
					'style-a-z' => esc_html__( 'Grid View : Top A to Z Filter', 'ivdirectories' ),
				],	
			]
			);
		$this->add_control(	
			'search_option',
				[
				'label'       		=> esc_html__( 'Search Form', 'ivdirectories' ),
				'type' 				=> 	Controls_Manager::SWITCHER,			
				'label_on' 			=> esc_html__( 'Show', 'textdomain' ),
				'label_off' 		=> esc_html__( 'Hide', 'textdomain' ),
				'return_value' 		=> 'yes',
				'default' 			=> 'yes',				
				]
			);
		
		$this->add_control(
			'map_option',
			[
			'label'       => esc_html__( 'Map Position', 'ivdirectories' ),
			'type'        => Controls_Manager::SELECT,
			'label_block' => true,			
			'default' => 'top',
				'options' => [
					'top'  => esc_html__( 'Top Map', 'ivdirectories' ),
					'right'  => esc_html__( 'Right Map', 'ivdirectories' ),
					'no'  => esc_html__( 'No Map', 'ivdirectories' ),
				],	
			]
			);
			
		$this->add_control(
			'category',
			[
				'label'       => esc_html__( 'Categories', 'ivdirectories' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => ep_dirpro_post_categories(),			
			]
		);
		$this->add_control(
			'locations',
			[
				'label'       => esc_html__( 'Locations', 'ivdirectories' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => ep_dirpro_post_locations(),			
			]
		);
		$this->add_control(
			'tag',
			[
				'label'       => esc_html__( 'Tags', 'ivdirectories' ),
				'type'        => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple'    => true,
				'options'     => ep_dirpro_post_tag(),			
			]
		);
		
		$this->end_controls_section();

	}

	//Render
	protected function render() {
		$settings = $this->get_settings_for_display();		
		$atts='';
		$main_shortcode="listing_layout_style_4";		
		if ( ! empty( $settings['template_option'] ) ) {
				if($settings['template_option']=='style-4'){
					$main_shortcode="listing_layout_style_4";
				}
				if($settings['template_option']=='style-5'){
					$main_shortcode="listing_layout_style_5";
				}
				if($settings['template_option']=='style-6'){
					$main_shortcode="listing_layout_faceted_grid";
				}
				if($settings['template_option']=='style-a-z'){
					$main_shortcode="listing_layout_grid_a_to_z_filter";
				}
		}
		
		if ( ! empty( $settings['map_option'] ) ) {			
			$atts=$atts.' map="'.$settings['map_option'].'"';
		}
		
		if ( ! empty( $settings['category'] ) ) {
			if(is_array($settings['category'])){
				$atts=$atts.' category="'.implode(",",$settings['category']).'"';
			}else{
				$atts=$atts.' category="'.$settings['category'].'"';
			}
		}
		if ( ! empty( $settings['locations'] ) ) {
			if(is_array($settings['locations'])){
				$atts=$atts.' locations="'.implode(",",$settings['locations']).'"';
			}else{
				$atts=$atts.' locations="'.$settings['locations'].'"';
			}
		}
		if ( ! empty( $settings['tag'] ) ) {
			if(is_array($settings['tag'])){
				$atts=$atts.' tag="'.implode(",",$settings['tag']).'"';
			}else{
				$atts=$atts.' tag="'.$settings['tag'].'"';
			}
		}
		if ( ! empty( $settings['search_option'] ) && $settings['search_option']=='yes') {		
			
				$atts=$atts.' search-form="yes"';
		}else{
			$atts=$atts.' search-form="no"';
		}
		
				
		$shortcode ="[".$main_shortcode." ".$atts." ]";		
		
		?>
		<div class="elementor-shortcode"><?php echo do_shortcode( shortcode_unautop( $shortcode ) );  ?></div>
		<?php
	}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Dirpro_Recent_Posts_Widget );
//Post Category
function ep_dirpro_post_categories() {
	$directory_url=get_option('_iv_directory_url');
	if($directory_url==""){$directory_url='directories';}
	$taxonomy = $directory_url.'-category';
	$args = array(
	'orderby'           => 'name',
	'order'             => 'ASC',
	'hide_empty'        => true,	
	);
	$terms = get_terms($taxonomy,$args);

	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
		foreach ( $terms as $term ) {
			$options[ $term->slug ] = $term->name;
		}
	}
	return $options;
}
//Post tag
function ep_dirpro_post_tag() {
	$directory_url=get_option('_iv_directory_url');
	if($directory_url==""){$directory_url='directories';}
	$taxonomy = $directory_url.'_tag';
	$args = array(
	'orderby'           => 'name',
	'order'             => 'ASC',
	'hide_empty'        => true,	
	);
	$terms = get_terms($taxonomy,$args);

	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
		foreach ( $terms as $term ) {
			$options[ $term->slug ] = $term->name;
		}
	}
	return $options;
}
//Post locations
function ep_dirpro_post_locations() {
	$directory_url=get_option('_iv_directory_url');
	if($directory_url==""){$directory_url='directories';}
	$taxonomy = $directory_url.'-locations';
	$args = array(
	'orderby'           => 'name',
	'order'             => 'ASC',
	'hide_empty'        => true,	
	);
	$terms = get_terms($taxonomy,$args);

	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
		foreach ( $terms as $term ) {
			$options[ $term->slug ] = $term->name;
		}
	}
	return $options;
}